/*
 * Decompiled with CFR 0.152.
 */
package com.alcatrazescapee.alcatrazcore.network;

import com.alcatrazescapee.alcatrazcore.AlcatrazCore;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

@ParametersAreNonnullByDefault
public abstract class PacketTContainerUpdate<T, D>
implements IMessage {
    protected final Capability<T> capability;
    final TIntObjectMap<D> capabilityData = new TIntObjectHashMap();
    EnumFacing targetFace;
    int windowID;

    protected PacketTContainerUpdate(Capability<T> capability) {
        this.capability = capability;
    }

    protected PacketTContainerUpdate(Capability<T> capability, @Nullable EnumFacing targetFace, int windowID, int slotID, T instance) {
        this.capability = capability;
        this.targetFace = targetFace;
        this.windowID = windowID;
        D data = this.readCapability(instance);
        if (data != null) {
            this.capabilityData.put(slotID, data);
        }
    }

    protected PacketTContainerUpdate(Capability<T> capability, @Nullable EnumFacing targetFace, int windowID, NonNullList<ItemStack> items) {
        this.capability = capability;
        this.targetFace = targetFace;
        this.windowID = windowID;
        for (int i = 0; i < items.size(); ++i) {
            D data;
            Object cap = ((ItemStack)items.get(i)).getCapability(capability, targetFace);
            if (cap == null || (data = this.readCapability(cap)) == null) continue;
            this.capabilityData.put(i, data);
        }
    }

    public final void fromBytes(ByteBuf buf) {
        this.windowID = buf.readInt();
        byte facingIndex = buf.readByte();
        this.targetFace = facingIndex >= 0 ? EnumFacing.func_82600_a((int)facingIndex) : null;
        int numEntries = buf.readInt();
        for (int i = 0; i < numEntries; ++i) {
            int index = buf.readInt();
            D data = this.deserializeCapability(buf);
            this.capabilityData.put(index, data);
        }
    }

    public final void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowID);
        if (this.targetFace != null) {
            buf.writeByte(this.targetFace.func_176745_a());
        } else {
            buf.writeByte(-1);
        }
        buf.writeInt(this.capabilityData.size());
        this.capabilityData.forEachEntry((index, data) -> {
            buf.writeInt(index);
            this.serializeCapability(buf, data);
            return true;
        });
    }

    public final boolean hasData() {
        return !this.capabilityData.isEmpty();
    }

    protected abstract D readCapability(T var1);

    protected abstract void serializeCapability(ByteBuf var1, D var2);

    protected abstract D deserializeCapability(ByteBuf var1);

    @ParametersAreNonnullByDefault
    public static abstract class Handler<T, D, M extends PacketTContainerUpdate<T, D>>
    implements IMessageHandler<M, IMessage> {
        public IMessage onMessage(M message, MessageContext ctx) {
            if (!((PacketTContainerUpdate)message).hasData()) {
                return null;
            }
            AlcatrazCore.getProxy().getThreadListener(ctx).func_152344_a(() -> {
                Container container;
                EntityPlayer player = AlcatrazCore.getProxy().getClientPlayer();
                if (message.windowID == 0) {
                    container = player.field_71069_bz;
                } else if (message.windowID == player.field_71070_bA.field_75152_c) {
                    container = player.field_71070_bA;
                } else {
                    return;
                }
                message.capabilityData.forEachEntry((index, data) -> {
                    ItemStack stack = container.func_75139_a(index).func_75211_c();
                    Object cap = stack.getCapability(message.capability, message.targetFace);
                    if (cap != null) {
                        this.applyCapability(stack, cap, data);
                    }
                    return true;
                });
            });
            return null;
        }

        public abstract void applyCapability(ItemStack var1, T var2, D var3);
    }
}

